unit mBinTree;

{ Rekursive Fassung (geeignet auch zum Ableiten von Suchbumen etc.)
  Stand: 30.01.2007
  Rckfragen und Verbesserungsvorschlge bitte an
  Joachim Deckers <za-klassen@deckers.name>
}

interface

type

   TBinTree = class
     private
       kenntInhalt: TObject;
       kenntLinkenNachfolger,
       kenntRechtenNachfolger: TBinTree;
     public
       constructor create;overload; virtual;
       constructor create(pItem:TObject);overload; virtual;
       constructor create(pItem:TObject;pLeftTree,pRightTree:TBintree);overload; virtual;
       procedure setRootItem(pItem:TObject); virtual;
       procedure setRightTree(pTree:TBintree); virtual;
       procedure setLeftTree(pTree:TBintree); virtual;
       function getRootItem:TObject; virtual;
       function getLeftTree:TBintree; virtual;
       function getRightTree:TBintree; virtual;
       function isEmpty:boolean; virtual;
       procedure clear; virtual;
       destructor destroy; override; 
     end;

implementation

uses Classes;

type Klassentyp = class of TBinTree;            

 constructor TBintree.create;                   // leeren Baum erzeugen
 begin
   kenntInhalt:=nil;
   kenntLinkenNachfolger:=nil;
   kenntRechtenNachfolger:=nil;
 end;

 constructor TBintree.create(pItem:TObject);    // Baum mit zwei leeren Teilbumen erzeugen
 begin
   kenntInhalt:=pItem;
   if pItem<>nil then                           // Ist pItem=nil, so wird nur ein leerer Baum erzeugt!
   begin
     kenntLinkenNachfolger:=Klassentyp(self.ClassType).create;
     kenntRechtenNachfolger:=Klassentyp(self.ClassType).create;
   end
   else
   begin
     kenntLinkenNachfolger:=nil;
     kenntRechtenNachfolger:=nil;
   end
 end;

 constructor TBintree.create(pItem:TObject;pLeftTree,pRightTree:TBintree);
 begin
   kenntInhalt:=pItem;
   if (pItem<>nil) and (pLeftTree<>nil) and (pRightTree<>nil) then // Ist ein Parameter nil, so wird nur ein leerer Baum erzeugt!
   begin
     kenntLinkenNachfolger:=pLeftTree;
     kenntRechtenNachfolger:=pRightTree;
   end
   else
   begin
     kenntLinkenNachfolger:=nil;
     kenntRechtenNachfolger:=nil;
   end
 end;

 procedure TBintree.setRootItem(pItem:TObject);
 begin
   if pItem<>nil then // pItem=nil wrde einen leeren Baum mit nichtleeren Teilbumen ermglichen
   begin
     if kenntInhalt=nil then
     begin
       kenntLinkenNachfolger:=Klassentyp(self.ClassType).create;
       kenntRechtenNachfolger:=Klassentyp(self.ClassType).create
     end;
     kenntInhalt:=pItem;
   end;
 end;

 procedure TBintree.setRightTree(pTree:TBintree);
 begin
   if (kenntInhalt<>nil) and (pTree<>nil) then
     kenntRechtenNachfolger:=pTree;
 end;

 procedure TBintree.setLeftTree(pTree:TBintree);
 begin
   if (kenntInhalt<>nil) and (pTree<>nil) then
     kenntLinkenNachfolger:=pTree;
 end;

 function TBintree.getRootItem:TObject;
 begin
   result:=kenntInhalt;
 end;

 function TBintree.getLeftTree:TBintree;
 begin
   result:=kenntLinkenNachfolger;
 end;

 function TBintree.getRightTree:TBintree;
 begin
   result:=kenntRechtenNachfolger;
 end;

 function TBintree.isEmpty:boolean;
 begin
   result:=kenntInhalt=nil;
 end;


 procedure TBintree.clear;
 begin
   if not self.isEmpty then
   begin
     kenntLinkenNachfolger.destroy;
     kenntLinkenNachfolger:=nil;
     kenntRechtenNachfolger.destroy;
     kenntRechtenNachfolger:=nil;
     // kenntInhalt.destroy;
     kenntInhalt:=nil;
   end;
 end;

 destructor TBintree.destroy;
 begin
   if not self.isEmpty then
     self.clear;
 end;


end.
